/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkDependencySetMerge;
import dev.jeka.core.api.depmanagement.JkFileSystemDependency;
import dev.jeka.core.api.depmanagement.JkLocalProjectDependency;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JkDependencySet {
    private final List<JkDependency> entries;
    private final Set<JkDependencyExclusion> globalExclusions;
    private final JkVersionProvider versionProvider;

    private JkDependencySet(List<? extends JkDependency> dependencies, Set<JkDependencyExclusion> exclusions, JkVersionProvider explicitVersions) {
        this.entries = Collections.unmodifiableList(dependencies);
        this.globalExclusions = Collections.unmodifiableSet(exclusions);
        this.versionProvider = explicitVersions;
    }

    public static JkDependencySet of(String dependencyDesc) {
        JkDependency dependency = JkModuleDependency.isModuleDependencyDescription(dependencyDesc) ? JkModuleDependency.of(dependencyDesc) : JkFileSystemDependency.of(Paths.get(dependencyDesc, new String[0]));
        return JkDependencySet.of(JkUtilsIterable.listOf(dependency));
    }

    public static JkDependencySet of() {
        return JkDependencySet.of(Collections.emptyList());
    }

    public static JkDependencySet of(List<? extends JkDependency> dependencies) {
        return new JkDependencySet(dependencies, Collections.emptySet(), JkVersionProvider.of());
    }

    public static JkDependencySet of(JkDependency dependency) {
        return JkDependencySet.of(JkUtilsIterable.listOf(dependency));
    }

    public List<JkDependency> getEntries() {
        return this.entries;
    }

    public JkDependencySet and(Hint hint, JkDependencySet other) {
        List<JkDependency> others = other.entries;
        JkDependencySet proto = this.and(other);
        LinkedList<JkDependency> result = new LinkedList<JkDependency>(this.entries);
        if (hint == null) {
            result.addAll(others);
            return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
        }
        if (!hint.condition) {
            return this;
        }
        if (hint.first) {
            result.addAll(0, others);
            return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
        }
        if (hint.before == null) {
            result.addAll(others);
            return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
        }
        int index = this.firstIndexMatching(hint.before);
        if (index == -1) {
            throw new IllegalArgumentException("No dependency " + hint.before + " found on " + result);
        }
        result.addAll(index, others);
        return new JkDependencySet(result, proto.globalExclusions, proto.versionProvider);
    }

    public JkDependencySet and(Hint hint, List<? extends JkDependency> others) {
        return this.and(hint, JkDependencySet.of(others));
    }

    private int firstIndexMatching(JkDependency dependency) {
        int i = 0;
        for (JkDependency dep : this.entries) {
            if (dep.matches(dependency)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JkDependencySet and(List<? extends JkDependency> others) {
        return this.and(null, others);
    }

    public JkDependencySet and(JkDependencySet other) {
        List deps = JkUtilsIterable.concatLists(this.entries, other.entries);
        HashSet<JkDependencyExclusion> newGlobalExcludes = new HashSet<JkDependencyExclusion>(this.globalExclusions);
        newGlobalExcludes.addAll(other.globalExclusions);
        JkVersionProvider newVersionProvider = this.versionProvider.and(other.versionProvider);
        return new JkDependencySet(deps, newGlobalExcludes, newVersionProvider);
    }

    public JkDependencySet and(Hint hint, JkDependency ... others) {
        return this.and(hint, Arrays.asList(others));
    }

    public JkDependencySet and(JkDependency ... others) {
        return this.and((Hint)null, others);
    }

    public JkDependencySet and(Hint hint, String moduleDescriptor) {
        return this.and(hint, JkModuleDependency.of(moduleDescriptor));
    }

    public JkDependencySet and(Hint hint, JkModuleId moduleId) {
        return this.and(hint, moduleId.toString());
    }

    public JkDependencySet and(JkModuleId moduleId) {
        return this.and(null, moduleId.toString());
    }

    public JkDependencySet and(String moduleDescriptor) {
        return this.and(null, moduleDescriptor);
    }

    public JkDependencySet and(Hint hint, String moduleDescriptor, JkTransitivity transitivity) {
        return this.and(hint, JkModuleDependency.of(moduleDescriptor).withTransitivity(transitivity));
    }

    public JkDependencySet and(String moduleDescriptor, JkTransitivity transitivity) {
        return this.and(null, moduleDescriptor, transitivity);
    }

    public JkDependencySet andFiles(Hint hint, Iterable<Path> paths) {
        if (JkUtilsPath.disambiguate(paths).isEmpty()) {
            return this;
        }
        return this.and(hint, JkFileSystemDependency.of(paths));
    }

    public JkDependencySet andFiles(Iterable<Path> paths) {
        return this.andFiles(null, paths);
    }

    public JkDependencySet andFiles(Hint hint, String ... paths) {
        return this.andFiles(hint, Stream.of(paths).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
    }

    public JkDependencySet andFiles(String ... paths) {
        return this.andFiles((Hint)null, paths);
    }

    public JkDependencySet minus(List<JkDependency> dependencies) {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>(this.getEntries());
        for (JkDependency dependency : dependencies) {
            JkDependency matchingDependency = this.getMatching(dependency);
            if (matchingDependency == null) continue;
            result.remove(matchingDependency);
        }
        return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet minus(JkDependency dependency) {
        List<JkDependency> list = JkUtilsIterable.listOf(dependency);
        return this.minus(list);
    }

    public JkDependencySet minus(Path path) {
        return this.minus(JkFileSystemDependency.of(path));
    }

    public JkDependencySet minus(JkModuleId moduleId) {
        return this.minus(JkModuleDependency.of(moduleId, JkVersion.UNSPECIFIED));
    }

    public JkDependencySet minus(String moduleId) {
        return this.minus(JkModuleId.of(moduleId));
    }

    public JkDependencySet withGlobalTransitivityReplacement(JkTransitivity formerTransitivity, JkTransitivity newTransitivity) {
        LinkedList<JkDependency> list = new LinkedList<JkDependency>();
        for (JkDependency dep : this.entries) {
            JkModuleDependency moduleDependency;
            if (dep instanceof JkModuleDependency && Objects.equals((moduleDependency = (JkModuleDependency)dep).getTransitivity(), formerTransitivity)) {
                dep = moduleDependency.withTransitivity(newTransitivity);
            }
            list.add(dep);
        }
        return new JkDependencySet(list, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet withTransitivity(String moduleId, JkTransitivity newTransitivity) {
        LinkedList<JkDependency> list = new LinkedList<JkDependency>();
        for (JkDependency dep : this.entries) {
            if (dep instanceof JkModuleDependency) {
                JkModuleDependency moduleDependency = (JkModuleDependency)dep;
                if (JkModuleId.of(moduleId).equals(moduleDependency.getModuleId())) {
                    dep = moduleDependency.withTransitivity(newTransitivity);
                }
            }
            list.add(dep);
        }
        return new JkDependencySet(list, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet mergeLocalProjectExportedDependencies() {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>();
        JkVersionProvider mergedVersionProvider = this.versionProvider;
        for (JkDependency dependency : this.entries) {
            if (dependency instanceof JkLocalProjectDependency) {
                JkLocalProjectDependency localProjectDependency = (JkLocalProjectDependency)dependency;
                result.add(localProjectDependency.withoutExportedDependencies());
                JkDependencySet exportedDependencies = localProjectDependency.getExportedDependencies();
                JkDependencySet recursiveExportedDependencies = exportedDependencies.mergeLocalProjectExportedDependencies();
                mergedVersionProvider = recursiveExportedDependencies.versionProvider.and(mergedVersionProvider);
                for (JkDependency exportedDependency : recursiveExportedDependencies.entries) {
                    JkDependency matchedDependency = this.getMatching(exportedDependency);
                    if (matchedDependency != null) continue;
                    result.add(exportedDependency);
                }
                continue;
            }
            result.add(dependency);
        }
        return new JkDependencySet(result, this.globalExclusions, mergedVersionProvider);
    }

    public JkDependencySet withVersionProvider(JkVersionProvider versionProvider) {
        return new JkDependencySet(this.entries, this.getGlobalExclusions(), versionProvider);
    }

    public JkDependencySet withResolvedBoms(JkRepoSet repos) {
        return this.withVersionProvider(this.versionProvider.withResolvedBoms(repos));
    }

    public JkDependencySet andBom(String dependencyDescription) {
        return this.withVersionProvider(this.versionProvider.andBom(dependencyDescription));
    }

    public JkDependencySet andVersionProvider(JkVersionProvider versionProvider) {
        return new JkDependencySet(this.entries, this.getGlobalExclusions(), this.versionProvider.and(versionProvider));
    }

    public boolean hasModules() {
        return this.entries.stream().filter(JkModuleDependency.class::isInstance).findAny().isPresent();
    }

    public JkVersionProvider getVersionProvider() {
        return this.versionProvider;
    }

    public String toString() {
        return this.entries.toString();
    }

    public JkModuleDependency get(String moduleId) {
        return this.moduleDeps().filter(dep -> dep.getModuleId().toString().equals(moduleId)).findFirst().orElse(null);
    }

    public <T extends JkDependency> T getMatching(T dependency) {
        return (T)((JkDependency)this.entries.stream().filter(dep -> dep.matches(dependency)).findFirst().orElse(null));
    }

    public List<JkModuleDependency> getModuleDependencies() {
        return this.moduleDeps().collect(Collectors.toList());
    }

    private Stream<JkModuleDependency> moduleDeps() {
        return this.entries.stream().filter(JkModuleDependency.class::isInstance).map(JkModuleDependency.class::cast);
    }

    public boolean hasDynamicVersions() {
        return this.moduleDeps().anyMatch(dep -> dep.getVersion().isDynamic());
    }

    public boolean hasDynamicAndResolvableVersions() {
        return this.moduleDeps().anyMatch(dep -> dep.getVersion().isDynamicAndResolvable());
    }

    public JkDependencySet withIdeProjectDir(Path ideProjectDir) {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>();
        for (JkDependency dependency : this.entries) {
            result.add(dependency.withIdeProjectDir(ideProjectDir));
        }
        return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet minusModuleDependenciesHavingIdeProjectDir() {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>();
        for (JkDependency dependency : this.entries) {
            if (dependency.getIdeProjectDir() != null && dependency instanceof JkModuleDependency) continue;
            result.add(dependency);
        }
        return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySetMerge merge(JkDependencySet other) {
        return JkDependencySetMerge.of(this, other);
    }

    public Set<Path> getIdePathDirs() {
        LinkedHashSet<Path> result = new LinkedHashSet<Path>();
        for (JkDependency dependency : this.entries) {
            if (dependency.getIdeProjectDir() == null) continue;
            result.add(dependency.getIdeProjectDir());
        }
        return result;
    }

    public JkDependencySet normalised(JkVersionedModule.ConflictStrategy conflictStrategy) {
        HashMap moduleIdVersionMap = new HashMap();
        this.entries.stream().filter(JkModuleDependency.class::isInstance).map(JkModuleDependency.class::cast).forEach(dep -> {
            moduleIdVersionMap.putIfAbsent(dep.getModuleId(), dep.getVersion());
            moduleIdVersionMap.computeIfPresent(dep.getModuleId(), (moduleId, version) -> JkVersionedModule.of(moduleId, version).resolveConflict(dep.getVersion(), conflictStrategy).getVersion());
        });
        List result = this.entries.stream().map(dependency -> {
            if (dependency instanceof JkModuleDependency) {
                JkModuleDependency moduleDependency = (JkModuleDependency)dependency;
                return moduleDependency.withVersion((JkVersion)moduleIdVersionMap.get(moduleDependency.getModuleId()));
            }
            return dependency;
        }).collect(Collectors.toList());
        return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet normalised() {
        return this.normalised(JkVersionedModule.ConflictStrategy.FAIL);
    }

    public JkDependencySet assertNoUnspecifiedVersion() {
        List unspecifiedVersionModules = this.getModuleDependencies().stream().filter(dep -> this.versionProvider.getVersionOfOrUnspecified(dep.getModuleId()).isUnspecified()).filter(dep -> dep.getVersion().isUnspecified()).collect(Collectors.toList());
        JkUtilsAssert.state(unspecifiedVersionModules.isEmpty(), "Following module does not specify version : " + unspecifiedVersionModules, new Object[0]);
        return this;
    }

    public JkDependencySet toResolvedModuleVersions() {
        List dependencies = this.entries.stream().map(dep -> {
            if (dep instanceof JkModuleDependency) {
                JkModuleDependency moduleDependency = (JkModuleDependency)dep;
                JkVersion providedVersion = this.versionProvider.getVersionOfOrUnspecified(moduleDependency.getModuleId());
                if (moduleDependency.getVersion().isUnspecified() && !providedVersion.isUnspecified()) {
                    return moduleDependency.withVersion(providedVersion);
                }
            }
            return dep;
        }).collect(Collectors.toList());
        return new JkDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public List<JkDependency> getVersionedDependencies() {
        return this.entries.stream().map(this.versionProvider::version).collect(Collectors.toList());
    }

    public List<JkModuleDependency> getVersionedModuleDependencies() {
        return this.getVersionedDependencies().stream().filter(JkModuleDependency.class::isInstance).map(JkModuleDependency.class::cast).collect(Collectors.toList());
    }

    public JkDependencySet withModuleDependenciesOnly() {
        List result = this.moduleDeps().collect(Collectors.toList());
        return new JkDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkDependencySet withLocalExclusions(JkDependencyExclusion ... exclusions) {
        if (this.entries.isEmpty()) {
            return this;
        }
        LinkedList<JkDependency> deps = new LinkedList<JkDependency>(this.entries);
        JkDependency last = deps.getLast();
        if (last instanceof JkModuleDependency) {
            JkModuleDependency moduleDependency = (JkModuleDependency)last;
            for (JkDependencyExclusion exclusion : exclusions) {
                moduleDependency = moduleDependency.andExclusion(exclusion);
            }
            deps.removeLast();
            deps.add(moduleDependency);
            return new JkDependencySet(deps, this.globalExclusions, this.versionProvider);
        }
        return this;
    }

    public JkDependencySet withLocalExclusions(String ... groupAndNames) {
        JkDependencyExclusion[] excludes = (JkDependencyExclusion[])Arrays.stream(groupAndNames).map(JkDependencyExclusion::of).toArray(JkDependencyExclusion[]::new);
        return this.withLocalExclusions(excludes);
    }

    public Set<JkDependencyExclusion> getGlobalExclusions() {
        return this.globalExclusions;
    }

    public JkDependencySet andGlobalExclusion(JkDependencyExclusion exclusion) {
        HashSet<JkDependencyExclusion> depExclusion = new HashSet<JkDependencyExclusion>(this.globalExclusions);
        depExclusion.add(exclusion);
        return new JkDependencySet(this.entries, depExclusion, this.versionProvider);
    }

    public JkDependencySet andGlobalExclusion(String groupAndName) {
        JkDependencyExclusion depExclusion = JkDependencyExclusion.of(groupAndName);
        return this.andGlobalExclusion(depExclusion);
    }

    public JkDependencySet withGlobalExclusion(Set<JkDependencyExclusion> excludes) {
        HashSet<JkDependencyExclusion> depExcludes = new HashSet<JkDependencyExclusion>(excludes);
        return new JkDependencySet(this.entries, Collections.unmodifiableSet(depExcludes), this.versionProvider);
    }

    public static String toJavaCode(int indentCount, List<JkDependency> dependencies, boolean and) {
        String method = and ? "and" : "minus";
        String indent = JkUtilsString.repeat(" ", indentCount);
        StringBuilder builder = new StringBuilder();
        for (JkDependency dependency : dependencies) {
            if (!(dependency instanceof JkModuleDependency)) continue;
            JkModuleDependency moduleDep = (JkModuleDependency)dependency;
            String dependencyString = moduleDep.getModuleId().getGroup() + ":" + moduleDep.getModuleId().getName();
            if (and && !moduleDep.getVersion().isUnspecified()) {
                dependencyString = dependencyString + ":" + moduleDep.getVersion().getValue();
            }
            builder.append(indent).append(".").append(method).append("(\"").append(dependencyString).append('\"').append(")\n");
        }
        return builder.toString();
    }

    public static class Hint {
        private final JkDependency before;
        private final boolean condition;
        private final boolean first;

        private Hint(JkDependency before, boolean condition, boolean first) {
            this.before = before;
            this.condition = condition;
            this.first = first;
        }

        public static Hint before(JkDependency dependency) {
            return new Hint(dependency, true, false);
        }

        public static Hint firstAndIf(boolean condition) {
            return new Hint(null, condition, true);
        }

        public static Hint first() {
            return Hint.firstAndIf(true);
        }

        public static Hint lastAndIf(boolean condition) {
            return new Hint(null, true, false);
        }

        public static Hint beforeAndIf(JkDependency dependency, boolean condition) {
            return new Hint(dependency, condition, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hint hint = (Hint)o;
            if (this.condition != hint.condition) {
                return false;
            }
            if (this.first != hint.first) {
                return false;
            }
            return this.before != null ? this.before.equals(hint.before) : hint.before == null;
        }

        public int hashCode() {
            int result = this.before != null ? this.before.hashCode() : 0;
            result = 31 * result + (this.condition ? 1 : 0);
            result = 31 * result + (this.first ? 1 : 0);
            return result;
        }
    }
}

