/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import java.util.Objects;
import java.util.Optional;

public final class JkDependencyExclusion {
    private final JkModuleId moduleId;
    private final JkModuleDependency.JkArtifactSpecification artifactSpecification;

    private JkDependencyExclusion(JkModuleId moduleId, JkModuleDependency.JkArtifactSpecification artifactSpecification) {
        this.moduleId = moduleId;
        this.artifactSpecification = artifactSpecification;
    }

    public static JkDependencyExclusion of(JkModuleId moduleId) {
        return new JkDependencyExclusion(moduleId, null);
    }

    public static JkDependencyExclusion of(String group, String name) {
        return JkDependencyExclusion.of(JkModuleId.of(group, name));
    }

    public static JkDependencyExclusion of(String groupAndName) {
        return JkDependencyExclusion.of(JkModuleId.of(groupAndName));
    }

    public JkDependencyExclusion withClassierAndType(String classifier, String type) {
        return new JkDependencyExclusion(this.moduleId, JkModuleDependency.JkArtifactSpecification.of(classifier, type));
    }

    public JkDependencyExclusion withType(String type) {
        return this.withClassierAndType(null, type);
    }

    public JkDependencyExclusion withClassifier(String classifier) {
        return this.withClassierAndType(classifier, null);
    }

    public JkModuleId getModuleId() {
        return this.moduleId;
    }

    public String getClassifier() {
        return Optional.ofNullable(this.artifactSpecification).map(spec -> spec.getClassifier()).orElse(null);
    }

    public String getType() {
        return Optional.ofNullable(this.artifactSpecification).map(spec -> spec.getType()).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkDependencyExclusion that = (JkDependencyExclusion)o;
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        return Objects.equals(this.artifactSpecification, that.artifactSpecification);
    }

    public int hashCode() {
        int result = this.moduleId.hashCode();
        result = 31 * result + (this.artifactSpecification != null ? this.artifactSpecification.hashCode() : 0);
        return result;
    }
}

