/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class JkComputedDependency
implements JkFileDependency {
    protected final Runnable runnable;
    protected final Iterable<Path> files;
    private final Path ideProjectDir;

    protected JkComputedDependency(Runnable runnable, Path ideProjectBaseDir, Iterable<Path> files) {
        this.runnable = runnable;
        this.files = files;
        this.ideProjectDir = ideProjectBaseDir;
    }

    public static JkComputedDependency of(final JkProcess process, Path ... files) {
        List<Path> fileSet = JkUtilsIterable.listWithoutDuplicateOf(Arrays.asList(files));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                process.exec(new String[0]);
            }

            public String toString() {
                return process.toString();
            }
        };
        return new JkComputedDependency(runnable, null, fileSet);
    }

    public static JkComputedDependency of(Runnable runnable, Path ... files) {
        List<Path> fileSet = JkUtilsIterable.listWithoutDuplicateOf(Arrays.asList(files));
        return new JkComputedDependency(runnable, null, fileSet);
    }

    public static JkComputedDependency of(Iterable<Path> files, JkJavaProcess process) {
        List<Path> fileSet = JkUtilsIterable.listWithoutDuplicateOf(JkUtilsPath.disambiguate(files));
        Runnable runnable = () -> process.exec(new String[0]);
        return new JkComputedDependency(runnable, null, fileSet);
    }

    public static JkComputedDependency of(Path file, JkJavaProcess process) {
        return JkComputedDependency.of(JkUtilsIterable.setOf(file), process);
    }

    public final boolean hasMissingFilesOrEmptyDirs() {
        return !this.getMissingFilesOrEmptyDirs().isEmpty();
    }

    public final Set<Path> getMissingFilesOrEmptyDirs() {
        LinkedHashSet<Path> files = new LinkedHashSet<Path>();
        for (Path file : this.files) {
            if (Files.exists(file, new LinkOption[0]) && (!Files.isDirectory(file, new LinkOption[0]) || JkPathTree.of(file).count(0, true) != 0)) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    public List<Path> getFiles() {
        Set<Path> missingFiles;
        if (this.hasMissingFilesOrEmptyDirs()) {
            JkLog.startTask("Build dependency : " + this, new Object[0]);
            this.runnable.run();
            JkLog.endTask();
        }
        if (!(missingFiles = this.getMissingFilesOrEmptyDirs()).isEmpty()) {
            throw new IllegalStateException(this + " didn't generate " + missingFiles);
        }
        LinkedList<Path> result = new LinkedList<Path>();
        this.files.forEach(path -> result.add((Path)path));
        return result;
    }

    @Override
    public Path getIdeProjectDir() {
        return this.ideProjectDir;
    }

    @Override
    public JkComputedDependency withIdeProjectDir(Path path) {
        return new JkComputedDependency(this.runnable, path, this.files);
    }

    public String toString() {
        return this.runnable.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkComputedDependency that = (JkComputedDependency)o;
        return this.files.equals(that.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }
}

