/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.crypto.gpg;

import dev.jeka.core.api.crypto.gpg.JkInternalGpgDoer;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.UnaryOperator;

public final class JkGpg {
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final JkInternalGpgDoer INTERNAL_GPG_DOER = JkInternalGpgDoer.of();
    private final Path pubRing;
    private final Path secRing;
    private final String passphrase;

    private JkGpg(Path pubRing, Path secRing, String password) {
        this.pubRing = pubRing;
        this.secRing = secRing;
        this.passphrase = password;
    }

    public static JkGpg of(Path pubRing, Path secRing, String password) {
        return new JkGpg(pubRing, secRing, password);
    }

    public static JkGpg ofStandardProject(Path baseDir) {
        Path localPub = baseDir.resolve("jeka").resolve("gpg/pubring.gpg");
        Path pub = JkUtilsPath.firstExisting(localPub, JkGpg.getDefaultPubring());
        if (pub == null) {
            pub = JkGpg.getDefaultPubring();
        }
        Path localSec = baseDir.resolve("jeka").resolve("gpg/secring.gpg");
        Path sec = JkUtilsPath.firstExisting(localSec, JkGpg.getDefaultSecring());
        if (sec == null) {
            sec = JkGpg.getDefaultSecring();
        }
        String secretKeyPassword = JkUtilsObject.firstNonNull(System.getProperty("jeka.gpg.passphrase"), System.getenv("JEKA_GPG_PASSPHRASE"), "");
        return JkGpg.of(pub, sec, secretKeyPassword);
    }

    public boolean isPublicAndSecretRingExist() {
        return Files.exists(this.pubRing, new LinkOption[0]) && Files.exists(this.secRing, new LinkOption[0]);
    }

    public static Path getDefaultPubring() {
        if (JkUtilsSystem.IS_WINDOWS) {
            return USER_HOME.resolve("AppData/Roaming/gnupg/pubring.gpg");
        }
        return USER_HOME.resolve(".gnupg/pubring.gpg");
    }

    public static Path getDefaultSecring() {
        if (JkUtilsSystem.IS_WINDOWS) {
            return USER_HOME.resolve("AppData/Roaming/gnupg/secring.gpg");
        }
        return USER_HOME.resolve(".gnupg/secring.gpg");
    }

    public static JkGpg ofDefaultGnuPg() {
        return new JkGpg(JkGpg.getDefaultPubring(), JkGpg.getDefaultSecring(), null);
    }

    public static JkGpg ofPublicRing(Path pubRing) {
        return JkGpg.of(pubRing, null, null);
    }

    public static JkGpg ofSecretRing(Path secRing, String password) {
        return JkGpg.of(null, secRing, password);
    }

    public Path sign(Path fileToSign, String keyname) {
        Path signatureFile = JkGpg.getSignatureFile(fileToSign);
        this.sign(fileToSign, keyname, signatureFile);
        return signatureFile;
    }

    public void sign(Path fileToSign, String keyName, Path signatureFile) {
        char[] pass = this.passphrase == null ? new char[]{} : this.passphrase.toCharArray();
        JkUtilsAssert.state(this.secRing != null, "You must supply a secret ring file (as secring.gpg) to sign files", new Object[0]);
        JkUtilsAssert.state(Files.exists(this.secRing, new LinkOption[0]), "Specified secret ring file " + this.secRing + " not found.", new Object[0]);
        INTERNAL_GPG_DOER.sign(fileToSign, this.secRing, keyName, signatureFile, pass, true);
    }

    public static Path getSignatureFile(Path fileToSign) {
        return fileToSign.getParent().resolve(fileToSign.getFileName().toString() + ".asc");
    }

    public boolean verify(Path fileToVerify, Path signature) {
        JkUtilsAssert.state(this.pubRing != null, "You must supply a public ring file (as pubring.gpg) to verify file signatures", new Object[0]);
        if (!Files.exists(this.getPublicRing(), new LinkOption[0])) {
            throw new IllegalStateException("Specified public ring file " + this.pubRing + " not found.");
        }
        return INTERNAL_GPG_DOER.verify(fileToVerify, this.pubRing, signature);
    }

    public JkGpg withSecretRing(Path file, String password) {
        return new JkGpg(this.pubRing, file, password);
    }

    public JkGpg withPublicRing(Path file) {
        return new JkGpg(file, this.secRing, this.passphrase);
    }

    public JkGpg withSecretRingPassword(String pwd) {
        return new JkGpg(this.pubRing, this.secRing, pwd);
    }

    public Path getSecretRing() {
        return this.secRing;
    }

    public Path getPublicRing() {
        return this.pubRing;
    }

    public UnaryOperator<Path> getSigner(String keyName) {
        JkUtilsAssert.argument(keyName != null, "Key name cannot be null. Use \"\" to select the first key present in " + this.secRing, new Object[0]);
        return new Signer(keyName);
    }

    private class Signer
    implements UnaryOperator<Path> {
        private final String keyName;

        private Signer(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public Path apply(Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                return null;
            }
            Path signatureFile = file.getParent().resolve(file.getFileName().toString() + ".asc");
            JkGpg.this.sign(file, this.keyName, signatureFile);
            return signatureFile;
        }
    }
}

