/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.idea.camelkideaplugin;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.NlsActions;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshProjectAction
extends AnAction {
    private final List<Path> paths;

    public RefreshProjectAction(@Nullable @NlsActions.ActionText String text, List<Path> paths) {
        super(text);
        this.paths = paths;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshProjectAction.$$$reportNull$$$0(0);
        }
        Project currentProject = e.getProject();
        ApplicationManager.getApplication().runWriteAction(() -> this.addLibraries(currentProject, this.paths));
    }

    private void addLibraries(Project currentProject, List<Path> libs) {
        ProjectRootManager.getInstance((Project)currentProject).orderEntries().forEachModule(m -> {
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)m).getModifiableModel();
            for (Path libPath : libs) {
                this.addCamelLibraryToModel(modifiableModel, libPath);
            }
            modifiableModel.commit();
            return true;
        });
    }

    private void addCamelLibraryToModel(ModifiableRootModel modifiableModel, Path libPath) {
        String libraryName;
        LibraryTable lt = modifiableModel.getModuleLibraryTable();
        if (lt.getLibraryByName(libraryName = this.sanitizeLibraryName(libPath)) == null) {
            Library camelFileLibrary = LibraryUtil.createLibrary((LibraryTable)lt, (String)libraryName);
            Library.ModifiableModel camelFileLibraryModifiableModel = camelFileLibrary.getModifiableModel();
            camelFileLibraryModifiableModel.addJarDirectory(libPath.getParent().toUri().toString(), false);
            camelFileLibraryModifiableModel.commit();
            ModuleRootModificationUtil.addDependency((Module)modifiableModel.getModule(), (Library)camelFileLibrary);
        }
    }

    @NotNull
    private String sanitizeLibraryName(Path libPath) {
        String nameWithoutVersion;
        String nameWithoutExtension = libPath.getFileName().toString().replace(".jar", "");
        String string = nameWithoutVersion = nameWithoutExtension.replaceAll("-([0-9]){1,2}\\.([0-9]){1,2}\\.([0-9]){1,2}.*", "");
        if (string == null) {
            RefreshProjectAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/apache/camel/k/idea/camelkideaplugin/RefreshProjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/apache/camel/k/idea/camelkideaplugin/RefreshProjectAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

