/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.idea.camelkideaplugin;

import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.NlsSafe;
import com.vdurmont.semver4j.Semver;

public class CamelVersionValidator
implements InputValidator {
    public static final String DEFAULT_CAMEL_VERSION = "3.16.0";
    private static final Semver MINIMUM_VERSION = new Semver("3.11.0");

    public boolean checkInput(@NlsSafe String inputString) {
        return inputString.matches("3\\.([0-9]){1,2}\\.([0-9]){1,2}.*");
    }

    public boolean canClose(@NlsSafe String inputString) {
        try {
            Semver semver = new Semver(inputString);
            return semver.isGreaterThan(MINIMUM_VERSION);
        }
        catch (Exception e) {
            return false;
        }
    }
}

