/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.idea.camelkideaplugin;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.k.idea.camelkideaplugin.CamelComponentValidator;
import org.apache.camel.k.idea.camelkideaplugin.DownloadUtil;
import org.apache.camel.k.idea.camelkideaplugin.RefreshProjectAction;
import org.apache.camel.k.idea.camelkideaplugin.settings.SettingsStateComponent;
import org.jetbrains.annotations.NotNull;

public class AddCamelComponent
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String version;
        if (e == null) {
            AddCamelComponent.$$$reportNull$$$0(0);
        }
        if ((version = SettingsStateComponent.getVersion(e)) == null) {
            return;
        }
        String component = Messages.showInputDialog((String)"Select the Apache Camel component to use (use commas do separate multiple components, ex.: camel-kafka,camel-caffeine)", (String)"Select component", null, null, (InputValidator)new CamelComponentValidator());
        if (component == null) {
            return;
        }
        final List<String> depList = Arrays.asList(component.replace(" ", "").split(","));
        Notification downloadStartNotification = new Notification("Camel K Idea Group", "Starting to download dependencies, this may take a while", NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)downloadStartNotification);
        try {
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.run((Task)new Task.Backgroundable(e.getProject(), "Downloading libraries"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<Path> libs = DownloadUtil.downloadDependencies(depList, version);
                    Notification downloadFinishedNotification = new Notification("Camel K Idea Group", "Downloaded dependencies", NotificationType.INFORMATION);
                    downloadFinishedNotification.addAction((AnAction)new RefreshProjectAction("Refresh project", libs));
                    Notifications.Bus.notify((Notification)downloadFinishedNotification);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/apache/camel/k/idea/camelkideaplugin/AddCamelComponent$1", "run"));
                }
            });
        }
        catch (Exception exception) {
            Notification downloadFailedNotification = new Notification("Camel K Idea Group", "Failed to download dependencies: " + exception.getMessage(), NotificationType.ERROR);
            Notifications.Bus.notify((Notification)downloadFailedNotification);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/apache/camel/k/idea/camelkideaplugin/AddCamelComponent", "actionPerformed"));
    }
}

